/*
* drv_disp_os.h- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/

#ifndef _DRV_DISP_OS_H_
#define _DRV_DISP_OS_H_

#include "drv_disp_os_header.h"

#ifdef _DRV_DISP_OS_C_
#define INTERFACE
#else
#define INTERFACE extern
#endif

INTERFACE void *DrvDispOsMemAlloc(u32 u32Size);
INTERFACE void DrvDispOsMemRelease(void *pPtr);
INTERFACE void DrvDispOsMsSleep(u32 u32Msec);
INTERFACE void DrvDispOsUsSleep(u32 u32Usec);
INTERFACE s32  DrvDispOsImiHeapAlloc(u32 u32Size, void **ppAddr);
INTERFACE void DrvDispOsImiHeapFree(void *pAddr);
INTERFACE bool DrvDispOsPadMuxActive(void);
INTERFACE bool DrvDispOsSetDeviceNode(void *pPlatFormDev);
INTERFACE bool DrvDispOsSetClkOn(void *pClkRate, u32 u32ClkRateSize);
INTERFACE bool DrvDispOsSetClkOff(void);
INTERFACE bool DrvDispOsCreateTask(DrvDispOsTaskConfig_t *pstTaskCfg, TaskEntryCb pTaskEntry, void *pDataPtr, char *pTaskName, bool bAuotStart);
INTERFACE bool DrvDispOsDestroyTask(DrvDispOsTaskConfig_t *pstTaskCfg);
INTERFACE u32  DrvDispOsGetSystemTime (void);
INTERFACE u64  DrvDispOsGetSystemTimeStamp (void);

#undef INTERFACE

#endif
